
cryptlog() {
	echo -n `date '+%b %d %H:%M:%S'` >> "$CRYPTLOG"
	echo " $@" >> "$CRYPTLOG"
}

# some tools such as wpasupplicant and thus configure_networking troncates stdout
# so we use a temp logfile for them and copy back in official logfile
copy_tmp_log() {
	if [ -s "$TMPCRYPTLOG" ]; then
		if [ "$VERBOSE" = "yes" ]; then
			echo '-------------------' >> "$CRYPTLOG"
			cat "$TMPCRYPTLOG" >> "$CRYPTLOG"
			echo '-------------------' >> "$CRYPTLOG"
		fi
		rm "$TMPCRYPTLOG"
	fi
}

create_hash() {
	rm -f "$HASH"
	local i localfile used_keys
	for i in $(get_key_ids) ; do
		localfile=$(get_localfile "$i")
		if [ ! -s "$localfile" ]; then
			rm -f "$HASH"
			return
		fi
		[ "$VERBOSE" = "yes" ] && cryptlog "concat $i from $localfile"
		cat "$localfile" >> "$HASH"
		used_keys="${used_keys}${i} "
	done
	cryptlog "create key with: $used_keys"
}

get_keyfile_with_ssh() {
	local options force
	options="$REMOTEOPT"
	force=$(echo $options | grep -E '( |^)(-q)( |$)')
	if [ "x$force" = "x" -a "$VERBOSE" = "yes" ]; then
		options="$options -v"
	fi
	[ "x$REMOTETIMEOUT" != "x" -a $REMOTETIMEOUT -ge 10 ] || REMOTETIMEOUT=10
	cryptlog "$SEARCHID: searching $REMOTEIP with ssh for ${REMOTEDIR}$KEYFILE"
	/usr/bin/ssh \
		-i /etc/opencrypt/opencrypt-ssh \
		-o ConnectTimeout=$REMOTETIMEOUT \
		-o UserKnownHostsFile=/etc/opencrypt/known_hosts \
		$options $REMOTEIP "cat ${REMOTEDIR}$KEYFILE" > "$LOCALFILE" 2>> "$TMPCRYPTLOG"
	copy_tmp_log
	[ -s "$LOCALFILE" ] && cryptlog "$SEARCHID: found key file with ssh put in $LOCALFILE"
}

get_keyfile_with_wget() {
	local options force
	options="$REMOTEOPT"
	force=$(echo $options | grep -E '( |^)(-v|--verbose|-q|--quiet)( |$)')
	if [ "x$force" = "x" ]; then
		if [ "$VERBOSE" = "yes" ]; then
			options="$options --verbose"
		else
			options="$options --quiet"
		fi
	fi
	[ "x$REMOTETIMEOUT" != "x" -a $REMOTETIMEOUT -ge 10 ] || REMOTETIMEOUT=10
	cryptlog "$SEARCHID: searching $REMOTEIP with wget for ${REMOTEDIR}$KEYFILE"
	# use real wget and not busybox for TLS handshake on https
	/usr/local/bin/wget \
		--ca-certificate /etc/opencrypt/opencrypt-ca.pem \
		--certificate /etc/opencrypt/opencrypt-cert.pem \
		--tries 1 --timeout $REMOTETIMEOUT $options \
		--output-document "$LOCALFILE" \
		"https://${REMOTEIP}/${REMOTEDIR}${KEYFILE}" >> "$TMPCRYPTLOG" 2>&1
	copy_tmp_log
	[ -s "$LOCALFILE" ] && cryptlog "$SEARCHID: found key file with wget put in $LOCALFILE"
}

get_keyfile_with_arp() {
	local address check
	cryptlog "$SEARCHID: searching $REMOTEIP for arp address"
	address=$(/usr/sbin/arp -a -n "$REMOTEIP" 2>&1 | sed 's/.* at // ; s/ .*//')
	check=$(echo "$address" | sed 's/[0-9a-f]/x/g')
	if [ "$check" = "xx:xx:xx:xx:xx:xx" ]; then
		echo "$address" > "$LOCALFILE"
	else
		cryptlog "invalid arp address for $REMOTEIP"
	fi
	[ -s "$LOCALFILE" ] && cryptlog "$SEARCHID: create key with arp put in $LOCALFILE"
}

get_keyfiles() {
	local i old new
	for i in $(get_search_ids) ; do
		load_key_params "$i"
		if [ "x$REMOTEIP" != "x" -a ! -s "$LOCALFILE" ]; then
			old=$REMOTEDIR
			new=$(echo "$old/" | sed "s/\/*$/\//")
			case "$REMOTEMODE" in
				ssh)
					get_keyfile_with_ssh
					if [ ! -s "$LOCALFILE" -a "$new" != "$old" ]; then
						REMOTEDIR=$new
						get_keyfile_with_ssh
						REMOTEDIR=$old
					fi
					;;
				wget)
					get_keyfile_with_wget
					if [ ! -s "$LOCALFILE" -a "$new" != "$old" ]; then
						REMOTEDIR=$new
						get_keyfile_with_wget
						REMOTEDIR=$old
					fi
					;;
				arp)
					get_keyfile_with_arp
					;;
			esac
		fi
	done
}

scan_network() {
	local masters master primary slaves slave

	cryptlog "searching network"

	# some networks could not interconnect to each others
	if [ -f "/sys/class/net/bonding_masters" ]; then
		masters=$(cat "/sys/class/net/bonding_masters")
		for master in $masters ; do
			cryptlog "parsing master $master"
			primary=$(cat "/sys/class/net/$master/bonding/primary")
			slaves=$(cat "/sys/class/net/$master/bonding/slaves")
			for slave in $slaves ; do
				if [ ! -s "$HASH" ]; then
					cryptlog "switching $master primary to $slave"
					echo "$slave" > "/sys/class/net/$master/bonding/primary"
					get_keyfiles
				fi
			done
			if [ "x$primary" != "x" ]; then
				cryptlog "restoring $master primary to $primary"
				echo "$primary" > "/sys/class/net/$master/bonding/primary"
			fi
		done
	fi

	# if no bonding or bonding has no slave try current network
	get_keyfiles
}

mount_devices() {
	local devices device infos mountpoint mounted
	cryptlog "mounting connected devices"
	if [ "x$DEVICELABEL" != "x" ]; then
		cryptlog "searching devices with label $DEVICELABEL"
		devices=$(/usr/sbin/blkid | grep -E "LABEL=\"($DEVICELABEL)\"" | cut -d: -f1 2>&1)
	elif [ "x$DEVICETYPE" != "x" ]; then
		cryptlog "searching devices with type $DEVICETYPE"
		devices=$(/usr/sbin/blkid | grep -E "TYPE=\"($DEVICETYPE)\"" | cut -d: -f1 2>&1)
	else
		cryptlog "searching devices not encrypted"
		devices=$(/usr/sbin/blkid | grep -v "TYPE=\"crypto_.*\"" | cut -d: -f1 2>&1)
	fi
	for device in $devices ; do
		infos=$(/usr/sbin/blkid $device)
		cryptlog "found device $infos"
		if [ -b "$device" ]; then
			mountpoint=$(echo "$device" | sed 's/\//_/g')
			mountpoint="$TMP2/$mountpoint"
			if [ ! -d "$mountpoint" ]; then
				mkdir -p "$mountpoint"
				mounted=$(mount | grep -E "^$device " | cut -d' ' -f3)
				if [ "x$mounted" = "x" ]; then
					cryptlog "mounting $device"
					mount -o ro "$device" "$mountpoint"
				else
					cryptlog "binding $device"
					mount --bind "$mounted" "$mountpoint"
					mount -o remount,bind,ro "$mounted" "$mountpoint"
				fi
			fi
		fi
	done
}

umount_devices() {
	cryptlog "umounting connected devices"
	local dir
	for dir in ${TMP2}/* ; do
		[ -d "$dir" ] && umount "$dir"
	done
}

scan_devices() {
	local dir device i

	cryptlog "searching devices"

	# mount all devices not already mounted
	# in case we search for multiple files on different devices
	# and devices could be plugged in after some loops
	mount_devices

	for dir in ${TMP2}/* ; do
		if [ -d "$dir" ]; then
			device=$(mount | grep "$dir " | cut -d' ' -f1)
			for i in $(get_search_ids) ; do
				load_key_params "$i"
				if [ "$REMOTEMODE" = "device" -a ! -s "$LOCALFILE" ]; then
					cryptlog "$SEARCHID: searching $device for ${DEVICEDIR}$KEYFILE"
					if [ -s "${dir}/${DEVICEDIR}${KEYFILE}" ]; then
						cryptlog "$SEARCHID: found ${DEVICEDIR}$KEYFILE on $device put in $LOCALFILE"
						cp "${dir}/${DEVICEDIR}${KEYFILE}" "$LOCALFILE"
					elif [ -s "${dir}/${DEVICEDIR}/${KEYFILE}" ]; then
						cryptlog "$SEARCHID: found ${DEVICEDIR}/$KEYFILE on $device put in $LOCALFILE"
						cp "${dir}/${DEVICEDIR}/${KEYFILE}" "$LOCALFILE"
					fi
				fi
			done
		fi
	done
}

