
load_params() {
    local param
    unset VERBOSE BOND WPASUPPLICANT
    unset WAITFOR OC_MODULES FIREWALL
    unset KEYBOARDKEYSLOT REMOTEKEYSLOT
    unset KEYBOARDTIMEOUT
    unset DEVICELABEL DEVICETYPE
    while read param ; do
		param=$(echo $param | sed -r 's/^ +// ; s/ +$// ; s/#.*$// ; s/^\[(SEARCH|KEY) .*\]//')
        if [ "x$param" != "x" ]; then
            eval $param
        fi
    done < $CONFFILE
    if [ "$VERBOSE" != "yes" ]; then
        VERBOSE="no"
    fi
    if [ "$BOND" != "yes" ]; then
        BOND="no"
    fi
    if [ "$WPASUPPLICANT" != "yes" ]; then
        WPASUPPLICANT="no"
    fi
}

unset_key_params() {
	unset KEYID REMOTEIP REMOTEMODE REMOTETIMEOUT REMOTEOPT REMOTEDIR REMOTEFILE DEVICEDIR LOCALFILE
	KEYID="$SEARCHID"
	REMOTEMODE="device"
}

get_remote_modes() {
    if [ "x$remote_modes_searched" = "x" ]; then
		for num in $(get_search_ids | sort) ; do
			load_key_params "$num"
			alreadythere=$(echo "$remote_modes" | grep -E "(^| )$REMOTEMODE($| )")
			if [ "x$REMOTEMODE" != "x" -a "x$alreadythere" = "x" ]; then
				remote_modes="$remote_modes $REMOTEMODE"
			fi
		done
        remote_modes_searched="done"
    fi
    echo $remote_modes
}

used_remote() {
    local remote used
    remote="$1"
    used=$(get_remote_modes | grep -E "$remote")
    [ "x$used" != "x" ] && return 0
    return 1
}

used_network_modes() {
	if used_remote "ssh|wget|arp" ; then
		return 0
	else
		return 1
	fi
}

get_search_ids() {
	local param num
    if [ "x$search_ids_searched" = "x" ]; then
		while read param ; do
			param=$(echo $param | sed 's/#.*$//')
			if [ "x$param" != "x" ]; then
				num=$(echo $param | grep -E "^ *\[(SEARCH|KEY) .*\]" | sed -r 's/^ *\[(SEARCH|KEY) +// ; s/\].*$// ; s/\W/_/g')
				alreadythere=$(echo "$search_ids" | grep -E "(^| )$num($| )")
				if [ "x$num" != "x" -a "x$alreadythere" = "x" ]; then
					search_ids="$search_ids $num"
				fi
			fi
		done < $CONFFILE
    	search_ids_searched="done"
	fi
	echo $search_ids
}

get_key_ids() {
	local param num
    if [ "x$key_ids_searched" = "x" ]; then
		for num in $(get_search_ids | sort) ; do
			load_key_params "$num"
			alreadythere=$(echo "$key_ids" | grep -E "(^| )$KEYID($| )")
			if [ "x$KEYID" != "x" -a "x$alreadythere" = "x" ]; then
				key_ids="$key_ids $KEYID"
			fi
		done
    	key_ids_searched="done"
	fi
	echo $key_ids
}

load_key_params() {
	local param found num
	SEARCHID="$1"
	unset_key_params
	found="no"
	while read param ; do
		param=$(echo $param | sed 's/#.*$//')
		if [ "x$param" != "x" ]; then
			num=$(echo $param | grep -E "^ *\[(SEARCH|KEY) .*\]" | sed -r 's/^ *\[(SEARCH|KEY) // ; s/\].*$// ; s/\W/_/g')
			if [ "x$num" != "x" ]; then
            	if [ "$found" = "yes" ]; then
					# we use only the first block with the searched id
					normalize_parameters
					return
				fi
				if [ "$num" = "$SEARCHID" ]; then
					unset_key_params
					found="yes"
				else
					found="no"
				fi
            elif [ "$found" = "yes" ]; then
				eval $param
			fi
		fi
	done < $CONFFILE
	normalize_parameters
}

get_localfile() {
	local id suffix
	id="$1"
	id=$(echo $id | sed 's/\W/_/g')
	suffix="all"
	[ "x$MAP" != "x" ] && suffix="$MAP"
	echo "${LOCALPREFIX}.${id}.${MAP}"
}

normalize_parameters() {
	local filename check
	REMOTETIMEOUT=$(echo "$REMOTETIMEOUT" | sed 's/[^0-9]//g')
	if [ "x$REMOTETIMEOUT" = "x" ]; then
	   REMOTETIMEOUT=10
	elif [ $REMOTETIMEOUT -lt 10 ] ; then
	   REMOTETIMEOUT=10
	fi
	if $(echo "$REMOTEIP" | grep :) ; then
		REMOTEIP=$(echo "$REMOTEIP" | sed 's/[^0-9a-fA-F:]//g')
	else
		REMOTEIP=$(echo "$REMOTEIP" | sed 's/[^0-9.]//g')
	fi
	if [ "x$DEVICEDIR" != "x" ]; then
		DEVICEDIR=$(echo "$DEVICEDIR" | sed 's/\/*$/\// ; s/^\/*//')
	fi
	if [ "$REMOTEMODE" = "device" ]; then
		if [ "x$DEVICEDIR" = "x" -a "x$REMOTEDIR" != "x" ]; then
			DEVICEDIR=$(echo "$REMOTEDIR" | sed 's/\/*$/\// ; s/^\/*//')
		fi
	fi
    check=$(echo "$CRYPT" | grep '^/')
    if [ "x$check" != "x" ]; then
        filename="$(echo "$CRYPT" | sed 's/.*\///').key"
    else
        filename="$(echo "$CRYPT" | cut -d'=' -f2).key"
    fi

	if [ "x$REMOTEFILE" != "x" ]; then
        KEYFILE="$REMOTEFILE"
    else
        KEYFILE="$filename"
    fi
	LOCALFILE=$(get_localfile "$KEYID")
}

is_remotemode_valid() {
	local mode=$1
    case "$mode" in
        device|ssh|wget|arp)
            return 0
            ;;
    esac
	return 1
}

