
Fonctionnement
--------------

Opencrypt permet d'avoir 0, 1 ou 2 clefs, réparties sur différents devices et/ou serveurs sur le réseau,
pour ouvrir automatiquement au boot les partitions cryptées.

Si plusieurs clefs sont demandées, opencrypt concatènera les clefs pour obtenir la clef réelle.
Les clefs peuvent être identiques ou spécifiques pour chaque partition à ouvrir.

Lors du boot opencrypt va essayer d'ouvrir toutes les partitions cryptées trouvées dans crypttab
(pas seulement la partition root).

Pour chaque partition opencrypt essaiera d'abord de trouver les clefs sur des devices non cryptés (clefs USB, etc).
Ensuite opencrypt cherchera les clefs manquantes sur le réseau.
Enfin si la partition cryptée n'a pas pû être ouverte, opencrypt demandera un mot de passe au clavier.

L'utilisation d'opencrypt dans le initrd suppose bien sûr que /boot est sur une partition séparée
et non cryptée. Car sinon son ouverture se ferait au niveau du bootloader (grub).


Premiers pas
------------

Le fichier de configuration fourni par défaut (en fait il est entièrement commenté !)
vous permettra lors du boot de saisir un mot de passe au clavier.
Donc pour un premier essai, laissez /etc/opencrypt/opencrypt.conf tel qu'il est,
ou éventuellement mettez VERBOSE="yes" pour avoir plus de détails,
et rebootez sur le initrd fraîchement créé lors de l'installation du paquet.
Vous pourrez ensuite analyser les logs dans /run/initramfs/opencrypt.log.


Configuration
-------------

Après installation du paquet et ce premier reboot, il faut renseigner
/etc/opencrypt/opencrypt.conf. La configuration fournie contient la description de
tous les paramètres ainsi que des exemples.

Quelque soit le paramétrage, opencrypt ne bloquera pas sur le réseau ou les devices
et finira par demander un mot de passe au clavier pour ouvrir les partitions cryptées.
Après un reboot vous pouvez consulter les logs dans /run/initramfs/opencrypt.log.

Après modification vous devez faire un update-initramfs pour mettre à jour votre initrd
avec tout ce qu'il faut.

  update-initramfs -u -k <VERSION>

update-initramfs fournit une auto-complétion pour voir les versions installées,
donc tapez juste le -k puis <TAB>

	>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> ATTENTION <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	Il est très très fortement conseillé de conserver un slot différent pour la clef
	manuelle (et d'utiliser éventuellement le paramètre KEYBOARDKEYSLOT dans
	opencrypt.conf). Cela vous permet de tester	l'installation sans risquer de perdre
	la partition. Libre à vous de supprimer ensuite	ce slot quand tout est fonctionnel.


Installation des clefs
----------------------

Pour tirer profit de l'automatisation, les clefs doivent être installées sur les supports externes.
Il faut placer les clefs :
- sur un device : dans le répertoire racine en DEVICEDIR/REMOTEFILE
- sur un serveur ssh : accessible par REMOTEIP:REMOTEDIR/REMOTEFILE
- sur un serveur web : accessible par https://REMOTEIP/REMOTEDIR/REMOTEFILE

Si le nom de la clef n'est pas précisé (avec REMOTEFILE) dans opencrypt.conf,
la clef recherchée dépendra du paramétrage trouvé dans crypttab :
- avec un device indiqué avec UUID, LABEL, PARTUUID ou PARTLABEL le fichier recherché
  sera <UUID|LABEL|PARTUUID|PARTLABEL>.key
  (utilisez blkid pour trouver les valeurs)
- avec un device indiqué par son nom (/dev/sda1, etc) le fichier recherché sera <BASENAME>.key
  par exemple pour /dev/sda1 on recherchera sda1.key

Pour la recherche des clefs sur des devices, si REMOTEFILE et DEVICEDIR sont vides ou identiques,
seule la première clef sera récupérée. En effet la deuxième clef serait la même sur les devices.
Si vous voulez cependant utiliser 2 clefs sur des devices, il vous faudra mettre des DEVICEDIR
différents. Si de plus REMOTEIP2 est vide, on utilisera uniquement la première clef, sans concaténation
donc, pour ouvrir la partition cryptée.


Fichiers supplémentaires
------------------------

opencrypt aura besoin de fichiers supplémentaires selon votre paramètrage.

* Pour mettre en place un firewall avec nft :

  /etc/opencrypt/nftables.conf       ruleset passé à nft

  Un exemple est disponible dans /usr/share/doc/opencrypt/examples/nftables.conf

  et apt install nftables

* Pour mettre en place un firewall avec iptables :

  /etc/opencrypt/iptables.conf       ruleset passé à iptables-restore
  et/ou
  /etc/opencrypt/ip6tables.conf      ruleset passé à ip6tables-restore

  et apt install iptables

* Pour wget :

  /etc/opencrypt/opencrypt-ca.pem    certificats de la CA pour valider le certificat du serveur contacté
  /etc/opencrypt/opencrypt-cert.pem  clef privée et certificat envoyé au serveur pour autoriser la connexion

  Il faut faire :

  chmod 600 /etc/opencrypt/opencrypt-cert.pem

  et apt install wget

* Pour ssh :

  /etc/opencrypt/known_hosts         les known_hosts pour valider les serveurs contactés
  /etc/opencrypt/opencrypt-ssh       clef privée qui doit être sans mot de passe
  /etc/opencrypt/opencrypt-ssh.pub   clef publique correspondante

  Il faut faire :

  chmod 600 /etc/opencrypt/known_hosts /etc/opencrypt/opencrypt-ssh

  et apt install openssh-client

Renommage
---------

update-initramfs ne rajoute pas correctement ce qu'il faut si on change les noms de mappage
dans /etc/crypttab et /etc/fstab.

opencrypt fait une copie de /etc/crypttab au moment de créer le initrd et l'utilisera au boot pour
un mappage supplémentaire des partitions cryptées. Cela veut dire que pour changer les noms de mappage
il suffit de les changer, dans /etc/crypttab et /etc/fstab, et de refaire le initrd.


Compléments
-----------

Voici quelques exemples de commandes utiles, à ne pas passer tel que mais à
adapter à votre système.

* formatter une partition cryptée

  créer la partition avec fdisk avec table GPT
  un mot de passe sera demandé et mis en slot 0

  cryptsetup --verbose luksFormat --verify-passphrase /dev/sda1

* pour ouvrir le cryptage
  et installer un système de fichier

  cryptsetup luksOpen /dev/sda1 TMP
  mkfs.xfs /dev/mapper/TMP

* pour fermer le cryptage

  cryptsetup close TMP

* ajouter des clefs

  en utilisant le mot de passe initial

  cryptsetup luksAddKey --new-keyfile sda1.key --new-key-slot=1 /dev/sda1

  en utilisant une clef déjà installée

  cryptsetup luksAddKey --key-file sda1.key --new-keyfile sda1.key2 --new-key-slot=2 /dev/sda1

* faire un backup du header
  indispensable si le disque a un problème

  cryptsetup luksHeaderBackup /dev/sda1 --header-backup-file sda1.backup

* mettre à jour un initrd
  (update-initramfs fournit une auto-complétion pour voir les versions installées)

  update-initramfs -u -k <VERSION>

* voir le contenu du initrd généré

  mkdir ramfs
  unmkinitramfs /boot/initrd.img-<VERSION> ramfs

* voir les partitions avec les UUID correspondants

  blkid

* générer une clef aléatoire de 64 caractères

  dd if=/dev/urandom bs=1 count=64 of=<filename.key> conv=excl,fsync

* ajouter les clefs à cryptsetup

  cat clef1 clef2 > clef

* tester les accès aux clefs sur un serveur web distant

  on suppose que le serveur web dispose d'un index.html accessible comme les clefs
  sinon dans la suite remplacez index.html par le chemin d'accès à votre clef
  tel que paramétré dans opencrypt.conf

  pour openssl il faut découper /etc/opencrypt/opencrypt-cert.pem en <clef privée> et <certificat>
  openssl doit indiquer "SSL_connect:SSL negotiation finished successfully"

  openssl s_client -connect 192.168.1.34:443 -key <clef privée> -cert <certificat> -CAfile /etc/opencrypt/opencrypt-ca.pem -state

  wget doit renvoyer "WARNING: Could not save SSL session data"
  car on n'envoie pas de certificat

  wget --no-check-certificate https://192.168.1.34/index.html

  wget doit récupérer correctement index.html

  wget --ca-certificate /etc/opencrypt/opencrypt-ca.pem --certificate /etc/opencrypt/opencrypt-cert.pem  https://192.168.1.34/index.html
  curl -vvv --cacert /etc/opencrypt/opencrypt-ca.pem --cert /etc/opencrypt/opencrypt-cert.pem https://192.168.1.34/index.html

